/** @file   MachineGun.h
 * @brief   Declaration of MachineGun class.
 * @version $Revision: 1.1 $
 * @date    $Date: 2006/03/16 21:10:03 $
 * @author  Tomi Lamminsaari
 */

#ifndef H_WWW_MACHINEGUN_H
#define H_WWW_MACHINEGUN_H

#include "GameObject.h"
#include "MCapturable.h"


namespace WeWantWar {

/** @class  MachineGun
 * @brief   Represents a big machinegun that can be controlled by player.
 * @author  Tomi Lamminsaari
 *
 */
class MachineGun : public GameObject, public MCapturable
{
public:

  ///
  /// Constants, datatypes and static methods
  /// =======================================

  /** Index of the no exiting counter. */
  static const int KNoExitCounterIndex = 1;
  /** Index of the reloading counter. */
  static const int KReloadCounterIndex = 0;
  
  /** Index of the controlpoint for gun nose 1 */
  static const int KGunNose1 = 0;
  /** Index of the controlpoint for gun nose 2. */
  static const int KGunNose2 = 1;
  
  
  ///
  /// Constructors, destructor and operators
  /// ======================================

  /** Default constructor.
   */
  MachineGun();

  /** Destructor
   */
  virtual ~MachineGun();

private:
  MachineGun( const MachineGun& aAnother );
  MachineGun& operator= ( const MachineGun& aAnother );
public:

  ///
  /// Inherited methods
  /// =================

  /** From GameObject
   */
  virtual void update();
  
  /** From GameObject
   */
  virtual void redraw( RedrawQueue* aQueue );
  
  /** From GameObject
   */
  virtual bool hitByBullet( Bullet* aBullet );
  
  /** From GameObject
   */
  virtual void makeSound( GameObject::SoundID aSoundId ) const;
  
  /** From GameObject
   */
  virtual void kill();
  
  /** From GameObject
   */
  virtual ObjectID::Type objectType() const;
  
  /** From GameObject
   */
  virtual bool reloading() const;

  /** From MCapturable
   */
  virtual void capture( GameObject* aMaster );
  
  /** From MCapturable
   */
  virtual void resurrect();
  
  /** From MCapturable
   */
  virtual bool canBeCaptured() const;
  
  /** From MCapturable
   */
  virtual GameObject* getMaster() const;


  ///
  /// New public methods
  /// ==================


  ///
  /// Getter methods
  /// ==============


protected:
  ///
  /// Protected interface
  /// ===================
  
  /** Handles the shooting.
   */
  void shoot();


protected:
  ///
  /// Data members
  /// ============
  
  /** Pointer to our master object when we're captured. */
  GameObject* iMaster;
  /** Index of the active gun pipe. */
  int iActiveGunNose;
};

};  // end of namespace

#endif
